﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.ComponentModel;
using System.Collections.ObjectModel;

namespace StudentsDatabase
{
    public partial class MainPage : PhoneApplicationPage
    {
        private StudentsDataContext studentsDB;

        private ObservableCollection<Student> students;
        public ObservableCollection<Student> Students
        {
            get
            {
                return students;
            }
            set
            {
                if (students != value)
                {
                    students = value;
                    NotifyPropertyChanged("Students");
                }
            }
        }

        // Constructor
        public MainPage()
        {
            InitializeComponent();

            studentsDB = new StudentsDataContext
                (StudentsDataContext.DBConnectionString);
            this.DataContext = this;
        }


        protected override void OnNavigatedTo
            (System.Windows.Navigation.NavigationEventArgs e)
        {
            var studentsInDB = from Student student in studentsDB.StudentsTable
                               select student;

            Students = new ObservableCollection<Student>(studentsInDB);
            base.OnNavigatedTo(e);
            //lbStudent.ItemsSource = students;
        }

        public event PropertyChangedEventHandler PropertyChanged;
        private void NotifyPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        private void btnCreateEntry_Click(object sender, RoutedEventArgs e)
        {
            Student newStudent = new Student();
            {
                newStudent.FirstName = txtBoxFirstName.Text;
                newStudent.LastName = txtBoxLastName.Text;
                newStudent.StudentNumber = Int64.Parse(txtBoxStudentNumber.Text);
            }

            Students.Add(newStudent);
            studentsDB.StudentsTable.InsertOnSubmit(newStudent);
            studentsDB.SubmitChanges();
            lbStudent.ItemsSource = students;
            txtBoxFirstName.Text = "";
            txtBoxLastName.Text = "";
            txtBoxStudentNumber.Text = "";
        }

        private void btnDeleteEntry_Click(object sender, RoutedEventArgs e)
        {
            Student deleteStudent = (Student)lbStudent.SelectedItem;

            Students.Remove(deleteStudent);
            studentsDB.StudentsTable.DeleteOnSubmit(deleteStudent);
            studentsDB.SubmitChanges();
        }
    }

    //Table
    [Table(Name = "Student")]
    public class Student : INotifyPropertyChanged, INotifyPropertyChanging
    {
        private int id;
        private string firstName;
        private string lastName;
        private long studentNumber;

        [Column(IsPrimaryKey = true, IsDbGenerated = true, DbType = "INT NOT NULL Identity", 
                CanBeNull = false, AutoSync = AutoSync.OnInsert)]
        public int ID
        {
            get
            {
                return id;
            }
            set
            {
                if (id != value)
                {
                    NotifyPropertyChanging("ID");
                    id = value;
                    NotifyPropertyChanged("ID");
                }
            }
        }

        [Column]
        public string FirstName
        {
            get
            {
                return firstName;
            }
            set
            {
                if (firstName != value)
                {
                    NotifyPropertyChanging("FirstName");
                    firstName = value;
                    NotifyPropertyChanged("FirstName");
                }
            }
        }

        [Column]
        public string LastName
        {
            get
            {
                return lastName;
            }
            set
            {
                if (lastName != value)
                {
                    NotifyPropertyChanging("LastName");
                    lastName = value;
                    NotifyPropertyChanged("LastName");
                }
            }
        }


        [Column]
        public long StudentNumber
        {
            get
            {
                return studentNumber;
            }
            set
            {
                if (studentNumber != value)
                {
                    NotifyPropertyChanging("StudentNumber");
                    studentNumber = value;
                    NotifyPropertyChanged("StudentNumber");
                }
            }
        }



        public event PropertyChangedEventHandler PropertyChanged;

        private void NotifyPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }
        public event PropertyChangingEventHandler PropertyChanging;

        private void NotifyPropertyChanging(string propertyName)
        {
            if (PropertyChanging != null)
            {
                PropertyChanging(this, new PropertyChangingEventArgs(propertyName));
            }
        }
    }

    //Datacontext
    public class StudentsDataContext : DataContext
    {
        public static string DBConnectionString = "Data Source=isostore:/Students.sdf";

        public StudentsDataContext(string connectionString)
            : base(connectionString)
        { }

        public Table<Student> StudentsTable;

    }
}

